/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import DE.siemens.ad.pdraw.figures.CommentTextFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.standard.CommentsContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class LinkCommentsHandle
extends LocatorHandle {
    protected FixedElbowConnection fConnection = new FixedElbowConnection();
    protected Figure fTarget = null;

    public LinkCommentsHandle(Figure owner, Locator l) {
        super(owner, l);
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Rectangle r = this.displayBox();
        this.fConnection.startPoint(r.x + r.width / 2, r.y + r.height / 2);
        this.fConnection.endPoint(x, y);
        Figure target1 = view.drawing().findFigureInsideWithout(x, y, this.fConnection);
        Figure target2 = view.drawing().findFigureWithout(x, y, this.fConnection);
        if (this.fTarget != null) {
            this.fTarget.invalidate();
        }
        if (target1 instanceof CommentsContainer) {
            this.fTarget = target1;
            ((CommentsContainer)((Object)this.fTarget)).showLinked();
        } else if (target2 instanceof CommentsContainer) {
            this.fTarget = target2;
            ((CommentsContainer)((Object)this.fTarget)).showLinked();
        } else {
            this.fTarget = null;
        }
        this.showReferenceInfo();
    }

    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        this.fConnection.startPoint(x, y);
        this.fConnection.endPoint(x, y);
        view.add(this.fConnection);
        this.fTarget = null;
        this.showReferenceInfo();
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        view.remove(this.fConnection);
        if (this.fTarget != null) {
            ((CommentTextFigure)this.owner()).connect(this.fTarget);
            this.fTarget.invalidate();
            view.checkDamage();
        }
        if (((CommentTextFigure)this.owner()).getObservedFigure() != null) {
            ((CommentTextFigure)this.owner()).getObservedFigure().invalidate();
        }
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.YELLOW);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.BLACK);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private void showReferenceInfo() {
        if (((CommentTextFigure)this.owner()).getObservedFigure() != null) {
            if (this.fTarget != null) {
                ((CommentTextFigure)this.owner()).getObservedFigure().invalidate();
            } else {
                ((CommentsContainer)((Object)((CommentTextFigure)this.owner()).getObservedFigure())).showLinked();
            }
        }
    }
}

